<?php
/**
 * این فایل باید از طریق Cron Job هر دقیقه اجرا شود
 * مثال دستور در cPanel: * * * * * /usr/bin/php /home/your_user/public_html/path/to/your/project/cron_delete.php
 */

require_once __DIR__ . '/config.php';
require_once __DIR__ . '/functions.php';

// 1. حذف کش‌های منقضی شده برای جلوگیری از بزرگ شدن جدول کش
try {
    db()->exec("DELETE FROM cache WHERE expire_at < NOW()");
} catch (Exception $e) {
    log_debug("خطا در حذف کش‌های منقضی: " . $e->getMessage());
}

// 2. حذف پیام‌های برنامه‌ریزی شده (مثل پیام‌های خودکار ربات)
try {
    $stmt = db()->prepare("SELECT k, v FROM cache WHERE k LIKE 'delete_msg_%' AND expire_at <= NOW() + INTERVAL 10 SECOND");
    $stmt->execute();
    $messages_to_delete = $stmt->fetchAll();
    
    $deleted_count = 0;
    $keys_to_remove_from_db = []; // آرایه‌ای برای نگهداری کلیدهایی که باید از دیتابیس حذف شوند

    foreach ($messages_to_delete as $row) {
        $data = json_decode($row['v'], true);
        $should_delete_from_cache = true; // فرض بر این است که این رکورد باید از کش حذف شود

        if ($data && isset($data['chat_id']) && isset($data['message_id']) && isset($data['delete_at'])) {
            // فقط اگر زمان حذف واقعاً رسیده باشد، درخواست حذف را بفرست
            if (time() >= $data['delete_at']) {
                $res = sendTelegram('deleteMessage', [
                    'chat_id' => $data['chat_id'],
                    'message_id' => $data['message_id']
                ]);
                
                if ($res && ($res['ok'] ?? false)) {
                    $deleted_count++;
                }
            } else {
                // اگر زمانش نرسیده بود، فعلاً از کش حذفش نکن
                $should_delete_from_cache = false;
            }
        }

        if ($should_delete_from_cache) {
            $keys_to_remove_from_db[] = $row['k'];
        }
    }
    
    // حذف تمام رکوردهای پردازش شده با یک کوئری بهینه
    if (!empty($keys_to_remove_from_db)) {
        $placeholders = implode(',', array_fill(0, count($keys_to_remove_from_db), '?'));
        db()->prepare("DELETE FROM cache WHERE k IN ($placeholders)")->execute($keys_to_remove_from_db);
    }
    
    if ($deleted_count > 0) {
        log_debug("✅ تعداد $deleted_count پیام برنامه‌ریزی شده با موفقیت حذف شد.");
    }
} catch (Exception $e) {
    log_debug("❌ خطا در Cron حذف پیام‌ها: " . $e->getMessage());
}

// 3. پاکسازی پیام‌های قدیمی از دیتابیس برای کنترل حجم
try {
    $deleted = db()->exec("DELETE FROM messages WHERE sent_at < DATE_SUB(NOW(), INTERVAL 30 DAY)");
    if ($deleted > 0) {
        log_debug("✅ تعداد $deleted پیام قدیمی از دیتابیس حذف شد.");
    }
} catch (Exception $e) {
    log_debug("❌ خطا در پاکسازی پیام‌های قدیمی: " . $e->getMessage());
}

log_debug("Cron job با موفقیت اجرا شد - " . date('Y-m-d H:i:s'));