<?php

function handleCommands($chat_id, $user_id, $text, $msg_id, $reply_to = null) {
    $text = trim($text);
    $user_role = getUserRole($chat_id, $user_id);
    
    // --- محدودیت کاربر ویژه ---
    if ($user_role === 'vip') {
        $allowed_vip_commands = [
            'تگ', 'تگ اعضا', 'منشن',
            'ایدی', 'اطلاعات', 'info',
            'لقب من', 'لقبم',
            '/start', '/start@' . BOT_USERNAME,
            '/help', 'راهنما'
        ];
        if (!in_array($text, $allowed_vip_commands)) {
            sendMessageWithAutoDelete($chat_id, "❌ شما به این دستور دسترسی ندارید.", $msg_id);
            return true;
        }
    }

    if ($text === '/start' || $text === '/start@' . BOT_USERNAME) {
        sendMessageWithAutoDelete($chat_id, "👋 سلام! من یک ربات مدیریت گروه هستم.\n\nبرای راهنما از دستور /help استفاده کنید.", $msg_id);
        return true;
    }

    if ($text === '/help' || $text === 'راهنما') {
        $help_text = "📖 <b>راهنمای ربات مدیریت گروه</b>\n\n";
        $help_text .= "🔹 <b>دستورات عمومی:</b>\n";
        $help_text .= "• ایدی / اطلاعات - نمایش اطلاعات کاربر\n";
        $help_text .= "• لقب من - نمایش لقب شما\n\n";
        
        if (!in_array($user_role, ['member'])) {
            $help_text .= "🔹 <b>دستورات مدیریتی:</b>\n";
            $help_text .= "• تگ / منشن - تگ کردن اعضا\n";
            $help_text .= "• تنظیم لقب [متن] - تنظیم لقب (روی پیام ریپلای)\n";
            $help_text .= "• حذف لقب - حذف لقب (روی پیام ریپلای)\n";
            $help_text .= "• سنجاق / پین - سنجاق کردن پیام\n";
            $help_text .= "• حذف سنجاق / آنپین - حذف سنجاق\n";
            $help_text .= "• قفل‌ها - مدیریت قفل‌های گروه\n";
            $help_text .= "• قفل [نوع] - قفل کردن نوع خاص\n";
            $help_text .= "• بازکردن [نوع] - باز کردن قفل\n\n";
            $help_text .= "<i>انواع قفل: لینک، استیکر، عکس، ویدیو، فایل، صدا، گیف، مخاطب، لوکیشن، فوروارد</i>";
        }
        
        if (isGroupOwner($chat_id, $user_id)) {
            $help_text .= "\n\n🔹 <b>دستورات مالک:</b>\n";
            $help_text .= "• افزودن مدیر - افزودن مدیر ربات\n";
            $help_text .= "• حذف مدیر - حذف مدیر ربات\n";
            $help_text .= "• لیست مدیران - نمایش لیست مدیران\n";
            $help_text .= "• افزودن ویژه - افزودن کاربر ویژه\n";
            $help_text .= "• حذف ویژه - حذف کاربر ویژه\n";
            $help_text .= "• لیست ویژه - نمایش کاربران ویژه\n";
            $help_text .= "• مالک‌سازی - تعیین مالک اختصاصی\n";
            $help_text .= "• لیست مالکان - نمایش تمام مالکان گروه";
        }
        
        sendMessageWithAutoDelete($chat_id, $help_text, $msg_id, 120);
        return true;
    }

    if (in_array($text, ['قفل‌ها', 'قفل ها', 'locks'])) {
        if (!canManageLocks($chat_id, $user_id)) {
            sendMessageWithAutoDelete($chat_id, "❌ شما دسترسی ندارید.", $msg_id);
            return true;
        }
        showLockMenu($chat_id, $msg_id);
        return true;
    }

    // =============================
    // دستورات مالک (فقط owner_bot و owner_group)
    // =============================
    if (in_array($text, ['افزودن مدیر', 'اد ادمین'])) {
        if (!isGroupOwner($chat_id, $user_id)) {
            sendMessageWithAutoDelete($chat_id, "❌ فقط سازنده گروه یا مالک ربات می‌تواند مدیر اضافه کند.", $msg_id);
            return true;
        }
        if (!$reply_to || !isset($reply_to['from']['id']) || !is_numeric($reply_to['from']['id'])) {
            sendMessageWithAutoDelete($chat_id, "❌ روی پیام کاربر مورد نظر ریپلای کنید.", $msg_id);
            return true;
        }
        $target_id = (int)$reply_to['from']['id'];
        $existing_role = getUserRole($chat_id, $target_id);
        if (in_array($existing_role, ['owner_bot', 'owner_group', 'owner_assigned'])) {
            sendMessageWithAutoDelete($chat_id, "❌ این کاربر قبلاً مالک است.", $msg_id);
            return true;
        }
        if (is_array($existing_role) && $existing_role['role'] === 'admin') {
            sendMessageWithAutoDelete($chat_id, "⚠️ این کاربر قبلاً مدیر است.", $msg_id);
            return true;
        }
        showAdminSetupPanel($chat_id, $user_id, $target_id, $msg_id);
        return true;
    }

    if (in_array($text, ['حذف مدیر', 'دل ادمین'])) {
        if (!isGroupOwner($chat_id, $user_id)) {
            sendMessageWithAutoDelete($chat_id, "❌ فقط سازنده گروه یا مالک ربات می‌تواند مدیر حذف کند.", $msg_id);
            return true;
        }
        if (!$reply_to || !isset($reply_to['from']['id']) || !is_numeric($reply_to['from']['id'])) {
            sendMessageWithAutoDelete($chat_id, "❌ روی پیام مدیر مورد نظر ریپلای کنید.", $msg_id);
            return true;
        }
        $target_id = (int)$reply_to['from']['id'];
        $stmt = db()->prepare("SELECT 1 FROM bot_admins WHERE chat_id = ? AND user_id = ?");
        $stmt->execute([$chat_id, $target_id]);
        if (!$stmt->fetch()) {
            sendMessageWithAutoDelete($chat_id, "❌ این کاربر مدیر ربات نیست.", $msg_id);
            return true;
        }
        db()->prepare("DELETE FROM bot_admins WHERE chat_id = ? AND user_id = ?")->execute([$chat_id, $target_id]);
        sendMessageWithAutoDelete($chat_id, "✅ مدیر " . formatUserMention($target_id) . " حذف شد.", $reply_to['message_id']);
        return true;
    }

    if (in_array($text, ['لیست مدیران', 'لیست ادمین'])) {
        if (!canManageLocks($chat_id, $user_id)) {
            sendMessageWithAutoDelete($chat_id, "❌ شما دسترسی مشاهده لیست مدیران را ندارید.", $msg_id);
            return true;
        }
        $stmt = db()->prepare("SELECT user_id FROM bot_admins WHERE chat_id = ?");
        $stmt->execute([$chat_id]);
        $admins = $stmt->fetchAll(PDO::FETCH_COLUMN);
        if (empty($admins)) {
            sendMessageWithAutoDelete($chat_id, "📋 هیچ مدیر ربات ثبت نشده است.", $msg_id);
            return true;
        }
        $list_text = "👨‍💼 <b>لیست مدیران ربات:</b>\n\n";
        foreach ($admins as $admin_id) {
            $list_text .= "• " . formatUserMention($admin_id) . "\n";
        }
        $list_text .= "\n📊 تعداد کل: " . count($admins) . " نفر";
        sendMessageWithAutoDelete($chat_id, $list_text, $msg_id, 120);
        return true;
    }

    if (in_array($text, ['افزودن ویژه', 'اد ویژه', 'add vip'])) {
        if (!isGroupOwner($chat_id, $user_id)) {
            sendMessageWithAutoDelete($chat_id, "❌ فقط سازنده گروه یا مالک ربات می‌تواند کاربر ویژه اضافه کند.", $msg_id);
            return true;
        }
        if (!$reply_to || !isset($reply_to['from']['id']) || !is_numeric($reply_to['from']['id'])) {
            sendMessageWithAutoDelete($chat_id, "❌ روی پیام کاربر ریپلای کنید.", $msg_id);
            return true;
        }
        $target_id = (int)$reply_to['from']['id'];
        $stmt = db()->prepare("SELECT 1 FROM vip_users WHERE chat_id = ? AND user_id = ?");
        $stmt->execute([$chat_id, $target_id]);
        if ($stmt->fetch()) {
            sendMessageWithAutoDelete($chat_id, "⚠️ این کاربر قبلاً ویژه است.", $msg_id);
            return true;
        }
        db()->prepare("INSERT INTO vip_users (chat_id, user_id, added_by, added_at) VALUES (?, ?, ?, NOW())")->execute([$chat_id, $target_id, $user_id]);
        sendMessageWithAutoDelete($chat_id, "⭐ کاربر " . formatUserMention($target_id) . " به لیست ویژه اضافه شد.", $reply_to['message_id']);
        return true;
    }

    if (in_array($text, ['حذف ویژه', 'دل ویژه', 'remove vip'])) {
        if (!isGroupOwner($chat_id, $user_id)) {
            sendMessageWithAutoDelete($chat_id, "❌ فقط سازنده گروه یا مالک ربات می‌تواند کاربر ویژه حذف کند.", $msg_id);
            return true;
        }
        if (!$reply_to || !isset($reply_to['from']['id']) || !is_numeric($reply_to['from']['id'])) {
            sendMessageWithAutoDelete($chat_id, "❌ روی پیام کاربر ریپلای کنید.", $msg_id);
            return true;
        }
        $target_id = (int)$reply_to['from']['id'];
        $stmt = db()->prepare("SELECT 1 FROM vip_users WHERE chat_id = ? AND user_id = ?");
        $stmt->execute([$chat_id, $target_id]);
        if (!$stmt->fetch()) {
            sendMessageWithAutoDelete($chat_id, "❌ این کاربر در لیست ویژه نیست.", $msg_id);
            return true;
        }
        db()->prepare("DELETE FROM vip_users WHERE chat_id = ? AND user_id = ?")->execute([$chat_id, $target_id]);
        sendMessageWithAutoDelete($chat_id, "✅ کاربر " . formatUserMention($target_id) . " از لیست ویژه حذف شد.", $reply_to['message_id']);
        return true;
    }

    if (in_array($text, ['لیست ویژه', 'ویژه‌ها', 'vip list'])) {
        if (!canManageLocks($chat_id, $user_id)) {
            sendMessageWithAutoDelete($chat_id, "❌ شما دسترسی مشاهده لیست ویژه را ندارید.", $msg_id);
            return true;
        }
        $stmt = db()->prepare("SELECT user_id FROM vip_users WHERE chat_id = ?");
        $stmt->execute([$chat_id]);
        $vips = $stmt->fetchAll(PDO::FETCH_COLUMN);
        if (empty($vips)) {
            sendMessageWithAutoDelete($chat_id, "🌟 هیچ کاربر ویژه‌ای وجود ندارد.", $msg_id);
            return true;
        }
        $list_text = "🌟 <b>لیست کاربران ویژه:</b>\n\n";
        foreach ($vips as $uid) {
            $list_text .= "• " . formatUserMention($uid) . "\n";
        }
        $list_text .= "\n📊 تعداد: " . count($vips) . " نفر";
        sendMessageWithAutoDelete($chat_id, $list_text, $msg_id, 120);
        return true;
    }

    if (in_array($text, ['مالک‌سازی', 'اونر سازی'])) {
        if (!isGroupOwner($chat_id, $user_id)) {
            sendMessageWithAutoDelete($chat_id, "❌ فقط سازنده گروه یا مالک ربات می‌تواند مالک اختصاصی تعیین کند.", $msg_id);
            return true;
        }
        if (!$reply_to || !isset($reply_to['from']['id']) || !is_numeric($reply_to['from']['id'])) {
            sendMessageWithAutoDelete($chat_id, "❌ روی پیام کاربر ریپلای کنید.", $msg_id);
            return true;
        }
        $target_id = (int)$reply_to['from']['id'];
        $stmt = db()->prepare("SELECT 1 FROM group_owners WHERE chat_id = ? AND user_id = ?");
        $stmt->execute([$chat_id, $target_id]);
        if ($stmt->fetch()) {
            sendMessageWithAutoDelete($chat_id, "⚠️ این کاربر قبلاً مالک اختصاصی است.", $msg_id);
            return true;
        }
        db()->prepare("INSERT INTO group_owners (chat_id, user_id, assigned_by, assigned_at) VALUES (?, ?, ?, NOW())")->execute([$chat_id, $target_id, $user_id]);
        sendMessageWithAutoDelete($chat_id, "👑 کاربر " . formatUserMention($target_id) . " به عنوان مالک اختصاصی تعیین شد.", $reply_to['message_id']);
        return true;
    }

    if (in_array($text, ['حذف مالک', 'دل اونر'])) {
        if (!isGroupOwner($chat_id, $user_id)) {
            sendMessageWithAutoDelete($chat_id, "❌ فقط سازنده گروه یا مالک ربات می‌تواند مالک اختصاصی را حذف کند.", $msg_id);
            return true;
        }
        if (!$reply_to || !isset($reply_to['from']['id']) || !is_numeric($reply_to['from']['id'])) {
            sendMessageWithAutoDelete($chat_id, "❌ روی پیام مالک ریپلای کنید.", $msg_id);
            return true;
        }
        $target_id = (int)$reply_to['from']['id'];
        $stmt = db()->prepare("SELECT 1 FROM group_owners WHERE chat_id = ? AND user_id = ?");
        $stmt->execute([$chat_id, $target_id]);
        if (!$stmt->fetch()) {
            sendMessageWithAutoDelete($chat_id, "❌ این کاربر مالک اختصاصی نیست.", $msg_id);
            return true;
        }
        db()->prepare("DELETE FROM group_owners WHERE chat_id = ? AND user_id = ?")->execute([$chat_id, $target_id]);
        sendMessageWithAutoDelete($chat_id, "✅ مالک " . formatUserMention($target_id) . " حذف شد.", $reply_to['message_id']);
        return true;
    }

    if (in_array($text, ['لیست مالکان', 'لیست اونر'])) {
        if (!isGroupOwner($chat_id, $user_id)) {
            sendMessageWithAutoDelete($chat_id, "❌ فقط سازنده گروه یا مالک ربات می‌تواند این لیست را ببیند.", $msg_id);
            return true;
        }

        $owners = [];
        $owners[] = "👑 مالک ربات: " . formatUserMention(OWNER_ID);

        $real_owner = getGroupOwnerFromChat($chat_id);
        if ($real_owner && (int)$real_owner !== OWNER_ID) {
            $owners[] = "👑 سازنده گروه: " . formatUserMention($real_owner);
        }

        $stmt = db()->prepare("SELECT user_id FROM group_owners WHERE chat_id = ?");
        $stmt->execute([$chat_id]);
        $assigned = $stmt->fetchAll(PDO::FETCH_COLUMN);
        foreach ($assigned as $uid) {
            if ((int)$uid !== OWNER_ID && (!isset($real_owner) || (int)$uid !== (int)$real_owner)) {
                $owners[] = "👑 مالک اختصاصی: " . formatUserMention($uid);
            }
        }

        $list_text = "👑 <b>لیست مالکان گروه:</b>\n\n" . implode("\n", $owners);
        sendMessageWithAutoDelete($chat_id, $list_text, $msg_id, 120);
        return true;
    }

    return false;
}

// ========== توابع کمکی ==========
function showAdminSetupPanel($chat_id, $issuer_id, $target_id, $reply_to_msg_id) {
    $hash = bin2hex(random_bytes(8));
    $panel_data = [
        'chat_id' => $chat_id,
        'issuer_id' => $issuer_id,
        'target_id' => $target_id,
        'reply_to_msg_id' => $reply_to_msg_id,
        'type' => 'admin_setup',
        'can_ban' => false,
        'can_mute' => false,
        'can_delete' => false,
        'can_pin' => false,
        'can_vip' => false
    ];
    setCache("panel_$hash", json_encode($panel_data), 300);

    $keyboard = ['inline_keyboard' => [
        [['text' => "🚫 بن ❌", 'callback_data' => "adm_ban_$hash"]],
        [['text' => "🔇 سکوت ❌", 'callback_data' => "adm_mute_$hash"]],
        [['text' => "🗑 حذف پیام ❌", 'callback_data' => "adm_delete_$hash"]],
        [['text' => "📌 سنجاق ❌", 'callback_data' => "adm_pin_$hash"]],
        [['text' => "⚙️ تنظیمات ❌", 'callback_data' => "adm_vip_$hash"]],
        [['text' => '✅ تایید و ذخیره', 'callback_data' => "adm_save_$hash"]],
        [['text' => '❌ انصراف', 'callback_data' => "adm_cancel_$hash"]]
    ]];

    $target_mention = formatUserMention($target_id);
    $result = sendTelegram('sendMessage', [
        'chat_id' => $chat_id,
        'text' => "🛠 <b>تنظیم دسترسی‌های مدیر</b>\n\n👤 کاربر: $target_mention\n\nدسترسی‌ها را با کلیک بر روی دکمه‌ها تنظیم کنید:",
        'parse_mode' => 'HTML',
        'reply_markup' => json_encode($keyboard),
        'reply_to_message_id' => $reply_to_msg_id
    ]);

    if ($result && isset($result['result']['message_id'])) {
        scheduleMessageDeletion($chat_id, $result['result']['message_id'], 120);
    }
}

function showLockMenu($chat_id, $reply_to_msg_id, $is_edit = false, $edit_msg_id = null, $hash = null) {
    $locks = [
        'link' => ['name' => 'لینک', 'icon' => '🔗'],
        'sticker' => ['name' => 'استیکر', 'icon' => '🎭'],
        'photo' => ['name' => 'عکس', 'icon' => '🖼'],
        'video' => ['name' => 'ویدیو', 'icon' => '🎬'],
        'document' => ['name' => 'فایل', 'icon' => '📄'],
        'voice' => ['name' => 'صدا', 'icon' => '🎤'],
        'animation' => ['name' => 'GIF', 'icon' => '🎞'],
        'contact' => ['name' => 'مخاطب', 'icon' => '👤'],
        'location' => ['name' => 'لوکیشن', 'icon' => '📍'],
        'forward' => ['name' => 'فوروارد', 'icon' => '↪️']
    ];

    $keyboard = ['inline_keyboard' => []];
    foreach ($locks as $lock_key => $info) {
        $is_locked = isLocked($chat_id, $lock_key);
        $status = $is_locked ? "🔒" : "🔓";
        $callback_data = $hash ? "lock_{$lock_key}_{$hash}" : "lock_{$lock_key}";
        $keyboard['inline_keyboard'][] = [['text' => "{$info['icon']} {$info['name']} $status", 'callback_data' => $callback_data]];
    }
    $done_callback = $hash ? "lock_done_{$hash}" : "lock_done";
    $keyboard['inline_keyboard'][] = [['text' => '✅ بستن', 'callback_data' => $done_callback]];

    $text = "🔐 <b>پنل مدیریت قفل‌ها</b>\n\n";
    $text .= "برای تغییر وضعیت، روی دکمه مربوطه کلیک کنید.\n\n";
    $text .= "<i>می‌توانید از دستورات متنی هم استفاده کنید:</i>\n";
    $text .= "• قفل [نوع]\n• بازکردن [نوع]";

    if ($is_edit && $edit_msg_id) {
        sendTelegram('editMessageText', [
            'chat_id' => $chat_id,
            'message_id' => $edit_msg_id,
            'text' => $text,
            'parse_mode' => 'HTML',
            'reply_markup' => json_encode($keyboard)
        ]);
    } else {
        $result = sendTelegram('sendMessage', [
            'chat_id' => $chat_id,
            'text' => $text,
            'parse_mode' => 'HTML',
            'reply_markup' => json_encode($keyboard),
            'reply_to_message_id' => $reply_to_msg_id
        ]);
        if ($result && isset($result['result']['message_id'])) {
            scheduleMessageDeletion($chat_id, $result['result']['message_id'], 120);
        }
    }
}